IF EXISTS ( SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_STATUS_NFE]') AND type IN (N'P',N'PC'))
BEGIN
	DROP PROCEDURE [DBO].[P_STATUS_NFE];
END;
GO
/*
=======================================================================================
'localizado..........: 
'Funo..............: 
'Objetivo............: Aumentar tamanho do campo ULT_MSG_RETORNO
'Tabelas.............:  
'Dt Modificao......: 16/05/2022
'Modificao.........: Aumentar tamanho do campo ULT_MSG_RETORNO
'=======================================================================================
Tag #A001 - Alterao do codigo  
Tag #I001 - Incluso de novo codigo 

*/
CREATE PROCEDURE [dbo].[P_STATUS_NFE] (@CD_FILIAL INT ,@CD_NF INT ,@TIPONOTA VARCHAR(1) )
AS
SET NOCOUNT ON;

--EXEC P_STATUS_NFE 090, 985906, 'S'
--CRIANDO TABELAS TEMPORARIAS

--Tag #A001
CREATE TABLE #RESULTADOS (
	CHAVE_NFE			VARCHAR(50)
	,DATA_ULT_ENVIO		DATETIME
	,ULT_MSG_RETORNO	VARCHAR(MAX)
	,PROT_CANCELAMENTO	VARCHAR(50)
	,DT_CANCELAMENTO	DATETIME
	,DS_RETORNO_CANCELAMENTO	VARCHAR(MAX)
	,ST_INUTILIZACAO			VARCHAR(50)
	,DT_INUTILIZACAO			DATETIME
	,DS_RETORNO_INUTILIZACAO	VARCHAR(MAX)
	,ULT_C_STAT					VARCHAR(MAX)
	,DATA_RECIBO				DATETIME
	,STS_CANCELAMENTO			INT 
	);


---ESCOPE VARIABLES            
DECLARE @ENVIADO_SEFAZ VARCHAR(1);
DECLARE @NR_NF INT;
DECLARE @CNPJ_FILIAL VARCHAR(20);
DECLARE @ID_ENVIO INT;

--************************************************************************--  
SET @CNPJ_FILIAL = ( SELECT REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(CGC, ' ', ''), '-', ''), '/', ''), '.', ''), '-', '')
					   FROM PRC_FILIAL
					  WHERE CD_FILIAL = @CD_FILIAL );

IF @TIPONOTA = 'S'
BEGIN
	SET @NR_NF = ( SELECT NF_NF
					 FROM EST_NF_SAI
					WHERE CD_FILIAL = @CD_FILIAL
					  AND CD_NF = @CD_NF
			);
END;
ELSE
BEGIN
	SET @NR_NF = ( SELECT NR_NF
					 FROM EST_NF_ENT
					WHERE CD_FILIAL = @CD_FILIAL
					  AND CD_NF = @CD_NF );
END;

SET @ID_ENVIO = ( SELECT MAX(L.ID)
				    FROM NFE..EST_NF_NFE_LOTE_NOTA O
						 INNER JOIN NFE..EST_NF_NFE_LOTE L ON L.ID = O.ID_LOTE
				   WHERE L.CNPJ = @CNPJ_FILIAL
					 AND O.NNF  = @NR_NF );

IF @ID_ENVIO > 0
	SET @ENVIADO_SEFAZ = 'S';


INSERT INTO #RESULTADOS
SELECT O.CHAVE_NFE
	  ,L.DH_RECIBO
	  ,O.DS_MOTIVO
	  ,C.PROTOCOLO
	  ,C.DH_CANCELAMENTO
	  ,C.DS_MOTIVO
	  ,I.STS_INUTILIZACAO
	  ,I.DH_INUTILIZACAO
	  ,I.DS_MOTIVO
	  ,L.ARQ_RECIBO_RETORNO
	  ,L.DH_RECIBO
	  ,C.STS_CANCELAMENTO
FROM NFe..EST_NF_NFE_LOTE_NOTA O
	 INNER JOIN NFE..EST_NF_NFE_LOTE L ON L.ID = O.ID_LOTE
	 LEFT JOIN NFE..EST_NF_NFE_CANCELAMENTO C ON C.CHAVE   = O.CHAVE_NFE
	 LEFT JOIN NFE..EST_NF_NFE_INUTILIZACAO I ON I.CNPJ    = @CNPJ_FILIAL
											 AND I.INICIAL = @NR_NF
											 AND I.MODELO  = '55'
WHERE O.ID_LOTE = @ID_ENVIO;

SELECT	 CHAVE_NFE
		,@ENVIADO_SEFAZ		AS ENVIADO_SEFAZ
		,DATA_ULT_ENVIO		AS DATA_ULT_ENVIO_VALIDACAO
		,ULT_MSG_RETORNO	AS ULT_MSG_RETORNO_VALIDACAO
		,PROT_CANCELAMENTO
		,DT_CANCELAMENTO
		,CASE WHEN PROT_CANCELAMENTO <> '' THEN 'S'
			  ELSE 'N'
		  END AS CANCELADA_SEFAZ
		,CASE WHEN DT_CANCELAMENTO IS NULL THEN 'N'
			  ELSE 'S'
		  END AS PEDIDO_CANCELAMENTO
		,DS_RETORNO_CANCELAMENTO
		,CASE WHEN ST_INUTILIZACAO IN (1,3) THEN 'S'
			  ELSE 'N'
		  END AS INUTILIZADA_SEFAZ
		,DT_INUTILIZACAO
		,DS_RETORNO_INUTILIZACAO
		,STS_CANCELAMENTO
FROM #RESULTADOS;
	--************************************************************************--  
	 

	